<?php

if (!current_user_can(get_option($this->shared->get('slug') . "_export_menu_capability"))) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'dalt'));
}

?>

<!-- output -->

<div class="wrap">

    <h2><?php esc_html_e('League Table - Export', 'dalt'); ?></h2>

    <div id="daext-menu-wrapper">

        <p><?php esc_html_e('Click the Export button to generate an XML file that includes all your tables.', 'dalt'); ?></p>

        <!-- the data sent through this form are handled by the export_xml_controller() method called with the WordPress init action -->
        <form method="POST" action="admin.php?page=dalt-export">

            <div class="daext-widget-submit">
                <input name="dalt_export" class="button button-primary" type="submit"
                       value="<?php esc_attr_e('Export', 'dalt'); ?>" <?php if ($this->shared->get_number_of_tables() == 0) {
                    echo 'disabled="disabled"';
                } ?>>
            </div>

        </form>

    </div>

</div>